function CDX = CDX_convert_parameters_AJD_idio(CDX)
% --------------------------------------------------------------------------------------------------
% Convert a CDX structure where cds.AJD describes the dynamics of X_i+ai*Y to a CDX structure where
% cds.AJD describes the dynamics of X_i only
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% --------------------------------------------------------------------------------------------------
% sample call: CDX_convert_parameters_AJD_idio(cdx_mor)
% --------------------------------------------------------------------------------------------------

% Extract common factor dynamics
ajd_common = CDX.AJD_common_factor;
y0 = CDX.y0;

% Convert cds.AJD
for i=1:length(CDX.portfolio)
    % Convert AJD dynamics
    cds = CDX.portfolio(i);
    [ajd_new, x0_new] = get_ajd_idio(cds, ajd_common, cds.dates{1}, cds.x0, y0);
    
    % Insert new values
    cds.AJD = ajd_new;
    cds.x0 = x0_new;
    CDX.portfolio(i) = cds;
end
